#!/usr/bin/env bash

#PUT THIS FILE IN ~/.local/share/rofi/finder.sh
#USE: rofi  -show find -modi find:~/.local/share/rofi/finder.sh
if [ ! "$@" ]
then
  echo -en "\0message\x1fSelect target directory\n"
  while read -r line; do
    echo "$line"
  done <<< $(find ~ -type d -path '*/\.*' -prune -o -not -name '.*' -type d -print) 
elif [ ! -n "${ROFI_DATA}" ]
then
  echo -en "\0message\x1fEnter file name. 'foo/bar' maps to '$@/foo/bar.png'\n"
  echo -en "\x00data\x1f$@\n"
  echo -en "Write file name\x00nonselectable\x1ftrue\n"
  while read -r line; do
    echo -en "$line\x00nonselectable\x1ftrue\n"
  done <<< $(find $@ -type d -path '*/\.*' -prune -o -not -name '.*' -type d -print) 
else
#  echo "${ROFI_DATA}/${@%/*}"
  NAME="/$@"
  coproc (mkdir -p "${ROFI_DATA}${NAME%/*}")
  echo "${ROFI_DATA}${NAME%/*}" > ~/test.txt
  echo "$NAME" > ~/test2.txt
  coproc ( scrot --select "${ROFI_DATA}/$@.png"  > /dev/null 2>&1 )
fi


exit
# Code below is ignored
if [ ! -z "$@" ]
then
  QUERY=$@
  if [[ "$@" == /* ]]
  then
    if [[ "$@" == *\?\? ]]
    then
      coproc ( scrot --select "${QUERY%\/* \?\?}"  > /dev/null 2>&1 )
      exec 1>&-
      exit;
    else
      coproc ( scrot --select "$@"  > /dev/null 2>&1 )
      exec 1>&-
      exit;
    fi
  elif [[ "$@" == \!\!* ]]
  then
    echo "!!-- Type your search query to find files"
    echo "!!-- To search again type !<search_query>"
    echo "!!-- To search parent directories type ?<search_query>"
    echo "!!-- You can print this help by typing !!"
  elif [[ "$@" == \?* ]]
  then
    echo "!!-- Type another search query"
    while read -r line; do
      echo "$line" \?\?
    done <<< $(find ~ -type d -path '*/\.*' -prune -o -not -name '.*' -type f,d -iname *"${QUERY#\?}"* -print) 
# -type f
  else
    echo "!!-- Type another search query"
    find ~ -type d -path '*/\.*' -prune -o -not -name '.*' -type f,d -iname *"${QUERY#!}"* -print
  fi
else
  echo "!!-- Type your search query to find files"
  echo "!!-- To seach again type !<search_query>"
  echo "!!-- To seach parent directories type ?<search_query>"
  echo "!!-- You can print this help by typing !!"
fi
